;;  Programm:      ACM-LSTAERKEANPASSEN.LSP
;;  Befehlsaufruf: ACM-LSTAERKEANPASSEN
;;  Funktion:      Weist Objekten eine Linienstrke zu.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         08.10.2022
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-lstaerkeanpassen ( / lwa37 lwa38 lwa06 lwa39 lwa40 lwa36 law01 law02 law03 law04 law05 law06 law07 law08 law09)
    (defun law01 ( / lwa04 lwa05)
      (setq lwa04 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= lwa04 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq lwa05 T)
            (setq lwa05 nil)
        )
        (if (not lwa05)
          (alert "\042acm-lstaerkeanpassen\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      lwa05
    )
    (defun law02 (lwa01 / )
      (if lwa06 (setq *error* lwa06))
      (if lwa37 (setvar "CMDECHO" lwa37))
      (if lwa27 (setvar "PICKBOX" lwa27))
      (setq lwa06 nil lwa37 nil lwa27 nil)
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun law03 (lwa02 lwa03 / lwa07 lwa08 lwa09 lwa10)
      (setq lwa07 (list -1 -2 -3 0 5 9 13 15 18 20 25 30 35 40 50 53 60 70 80 90 100 106 120 140 158 200 211))
        (if (< (getvar "LWUNITS") 1)
          (progn
            (setq lwa08 (list "_bylayer" "_byblock" "_default" "0.000" "0.002" "0.004" "0.005" "0.006" "0.007" "0.008" "0.010" "0.012" "0.014" "0.016" "0.020" "0.021" "0.024" "0.028" "0.031" "0.035" "0.039" "0.042" "0.047" "0.055" "0.062" "0.079" "0.083"))
            (setq lwa09 (list "VonLayer" "VonBlock" "Vorgabe" "0.000''" "0.002''" "0.004''" "0.005''" "0.006''" "0.007''" "0.008''" "0.010''" "0.012''" "0.014''" "0.016''" "0.020''" "0.021''" "0.024''" "0.028''" "0.031''" "0.035''" "0.039''" "0.042''" "0.047''" "0.055''" "0.062''" "0.079''" "0.083''"))
          )
          (progn
            (setq lwa08 (list "_bylayer" "_byblock" "_default" "0.00" "0.05" "0.09" "0.13" "0.15" "0.18" "0.20" "0.25" "0.30" "0.35" "0.40" "0.50" "0.53" "0.60" "0.70" "0.80" "0.90" "1.00" "1.06" "1.20" "1.40" "1.58" "2.00" "2.11"))
            (setq lwa09 (list "VonLayer" "VonBlock" "Vorgabe" "0.00 mm" "0.05 mm" "0.09 mm" "0.13 mm" "0.15 mm" "0.18 mm" "0.20 mm" "0.25 mm" "0.30 mm" "0.35 mm" "0.40 mm" "0.50 mm" "0.53 mm" "0.60 mm" "0.70 mm" "0.80 mm" "0.90 mm" "1.00 mm" "1.06 mm" "1.20 mm" "1.40 mm" "1.58 mm" "2.00 mm" "2.11 mm"))
          )
        )
      (setq lwa10 (nth (vl-position lwa03 lwa07) lwa08))
      (vl-cmdf "._chprop" lwa02 "" "_lweight" lwa10 "")
        (if (vl-position lwa36 (list 0 1))
          (setvar "LWDISPLAY" lwa36)
        )
      (prompt (strcat "\nLinienstrke von " (itoa (sslength lwa02)) " Objekt(en) angepasst. Neue Linienstrke: " (nth (vl-position lwa03 lwa07) lwa09) " "))
    )
    (defun law04 ( / lwa13 lwa11 lwa12)
      (if
        (and
          (setq lwa11 (vl-filename-mktemp "acm.dcl"))
          (setq lwa12 (open lwa11 "w"))
        )
          (progn
            (setq lwa13
              (list
                "acm_ccs"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.2;}"
                ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                ":spacer{height=0.3;}"
                ":toggle{key=\042tg_01\042;label=\042&Blockelemente whlbar\042;}"
                ":toggle{key=\042tg_02\042;label=\042&VonLayer ersetzen\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=0;}}}"
              )
            )
              (while lwa13
                (write-line (car lwa13) lwa12)
                (setq lwa13 (cdr lwa13))
              )
            (setq lwa12 (close lwa12))
            lwa11
          )
          nil
      )
    )
    (defun law05 ( / lwa14 lwa15 lwa16 lwa19)
        (if (setq lwa14 (law04))
          (progn
            (setq lwa15 (load_dialog lwa14))
              (if (not (new_dialog "acm_ccs" lwa15))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list lwa14))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa acmlineweightchange522200520c))
            (set_tile "tg_02" (itoa acmlineweightchange522200520d))
              (if (= acmlineweightchange522200520a 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa acmlineweightchange522200520b))
              )
              (action_tile "b_01" "(setq lwa16 (atoi (get_tile \"pl_01\")))
                  (if (= lwa16 0)
                    (progn
                      (setq acmlineweightchange522200520a 0)
                      (setq acmlineweightchange522200520b (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq acmlineweightchange522200520a 1)
                      (setq acmlineweightchange522200520b lwa16)
                    )
                  )
                (setq lwa19 (list (setq acmlineweightchange522200520c (atoi (get_tile \"tg_01\"))) (setq acmlineweightchange522200520d (atoi (get_tile \"tg_02\"))) acmlineweightchange522200520a acmlineweightchange522200520b))
                (done_dialog)
                (law06)"
              )
            (action_tile "b_02" "(setq lwa19 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog lwa15)
          )
        )
      lwa19
    )
    (defun law06 ( / )
      (if (not (vl-position acmlineweightchange522200520a (list 0 1)))
        (setq acmlineweightchange522200520a 0)
      )
      (if (not (vl-position acmlineweightchange522200520b (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
        (progn
          (setq acmlineweightchange522200520a 0)
          (setq acmlineweightchange522200520b (getvar "PICKBOX"))
        )
      )
      (if (not (vl-position acmlineweightchange522200520c (list 0 1)))
        (setq acmlineweightchange522200520c 0)
      )
      (if (not (vl-position acmlineweightchange522200520d (list 0 1)))
        (setq acmlineweightchange522200520d 0)
      )
      (prompt
        (strcat
          "\nAktuelle Einstellungen fr Wahl der Ziellinienstrke: Pickbox-Gre = "
            (if (= acmlineweightchange522200520a 0)
              (strcat "Aktuelle (" (itoa (getvar "PICKBOX")) ")")
              (itoa acmlineweightchange522200520b)
            )
          ", Blockelemente whlbar = "
          (nth acmlineweightchange522200520c (list "Nein" "Ja"))
          ", VonLayer ersetzen = "
          (nth acmlineweightchange522200520d (list "Nein" "Ja"))
        )
      )
    )
    (defun law07 ( / lwa07 lwa08 lwa23 lwa24 lwa25 lwa26 lwa27 lwa28 lwa29 lwa30 lwa31 lwa32 lwa33 lwa34)
      (setq lwa07 (list -1 -2 -3 0 5 9 13 15 18 20 25 30 35 40 50 53 60 70 80 90 100 106 120 140 158 200 211))
        (if (not (vl-position acmlineweightchange522200520e lwa07))
          (setq acmlineweightchange522200520e -1)
        )
        (if (< (getvar "LWUNITS") 1)
          (setq lwa08 (list "VonLayer" "VonBlock" "Vorgabe" "0.000''" "0.002''" "0.004''" "0.005''" "0.006''" "0.007''" "0.008''" "0.010''" "0.012''" "0.014''" "0.016''" "0.020''" "0.021''" "0.024''" "0.028''" "0.031''" "0.035''" "0.039''" "0.042''" "0.047''" "0.055''" "0.062''" "0.079''" "0.083''"))
          (setq lwa08 (list "VonLayer" "VonBlock" "Vorgabe" "0.00 mm" "0.05 mm" "0.09 mm" "0.13 mm" "0.15 mm" "0.18 mm" "0.20 mm" "0.25 mm" "0.30 mm" "0.35 mm" "0.40 mm" "0.50 mm" "0.53 mm" "0.60 mm" "0.70 mm" "0.80 mm" "0.90 mm" "1.00 mm" "1.06 mm" "1.20 mm" "1.40 mm" "1.58 mm" "2.00 mm" "2.11 mm"))
        )
        (if (/= acmlineweightchange522200520e -1)
          (progn
            (setq lwa23 "Vonlayer Auswahlliste Einstellungen")
            (setq lwa24 (strcat "\nZiellinienstrke durch Objekt whlen oder [Vonlayer/Auswahlliste/Einstellungen] <" (nth (vl-position acmlineweightchange522200520e lwa07) lwa08) ">: "))
          )
          (progn
            (setq lwa23 "Auswahlliste Einstellungen")
            (setq lwa24 "\nZiellinienstrke durch Objekt whlen oder [Auswahlliste/Einstellungen] <VonLayer>: ")
          )
        )
      (setq lwa25 (getvar "ERRNO"))
      (setvar "ERRNO" 7)
        (while (= (getvar "ERRNO") 7)
          (setvar "ERRNO" 0)
            (if (= acmlineweightchange522200520c 0)
              (setq lwa26 entsel)
              (setq lwa26 nentsel)
            )
          (setq lwa27 (getvar "PICKBOX"))
          (setvar "PICKBOX" acmlineweightchange522200520b)
          (initget lwa23)
          (setq lwa28 (lwa26 lwa24))
          (setvar "PICKBOX" lwa27)
            (if (not lwa28)
              (setq lwa29 acmlineweightchange522200520e)
              (progn
                (if (= (type lwa28) 'STR)
                  (progn
                    (if (= lwa28 "Vonlayer")
                      (setq lwa29 -1)
                    )
                    (if (= lwa28 "Auswahlliste")
                      (progn
                        (if (not (setq lwa29 (car (law09))))
                          (setvar "ERRNO" 7)
                        )
                      )
                    )
                    (if (= lwa28 "Einstellungen")
                      (progn
                        (law05)
                        (setvar "ERRNO" 7)
                        (setq lwa30 T)
                      )
                    )
                  )
                  (progn
                    (setq lwa31 (car lwa28))
                    (setq lwa32 (entget lwa31))
                    (setq lwa29 (cdr (assoc 370 lwa32)))
                      (if (not lwa29)
                        (progn
                          (if (= acmlineweightchange522200520d 0)
                            (setq lwa29 -1)
                            (progn
                              (setq lwa33 (tblobjname "LAYER" (cdr (assoc 8 lwa32))))
                              (setq lwa34 (entget lwa33))
                              (setq lwa29 (cdr (assoc 370 lwa34)))
                            )
                          )
                        )
                      )
                  )
                )
              )
            )
            (if
              (and
                (= (getvar "ERRNO") 7)
                (not lwa30)
              )
                (prompt "0 gefunden")
            )
          (setq lwa30 nil)
        )
        (if lwa25
          (setvar "ERRNO" lwa25)
        )
      (if lwa29
        (setq acmlineweightchange522200520e lwa29)
        nil
      )
    )
    (defun law08 ( / lwa13 lwa11 lwa12)
      (if
        (and
          (setq lwa11 (vl-filename-mktemp "acm.dcl"))
          (setq lwa12 (open lwa11 "w"))
        )
          (progn
            (setq lwa13
              (list
                "acm_clw"
                ":dialog{label=\042Ziellinienstrke whlen\042;initial_focus=\042lb_01\042;"
                ":spacer{height=0.2;}"
                ":list_box{key=\042lb_01\042;height=12;allow_accept=true;}"
                ":spacer{height=0;}"
                ":toggle{key=\042tg_01\042;label=\042Linienstrke &anzeigen\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=1;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=1;}}}"
              )
            )
              (while lwa13
                (write-line (car lwa13) lwa12)
                (setq lwa13 (cdr lwa13))
              )
            (setq lwa12 (close lwa12))
            lwa11
          )
          nil
      )
    )
    (defun law09 ( / lwa14 lwa15 lwa07 lwa08 lwa35 lwa19)
        (if (setq lwa14 (law08))
          (progn
            (setq lwa15 (load_dialog lwa14))
              (if (not (new_dialog "acm_clw" lwa15))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list lwa14))
            (setq lwa07 (list -1 -2 -3 0 5 9 13 15 18 20 25 30 35 40 50 53 60 70 80 90 100 106 120 140 158 200 211))
              (if (not (vl-position acmlineweightchange522200520e lwa07))
                (setq acmlineweightchange522200520e -1)
              )
              (if (< (getvar "LWUNITS") 1)
                (setq lwa08 (list "VonLayer" "VonBlock" "Vorgabe" "0.000''" "0.002''" "0.004''" "0.005''" "0.006''" "0.007''" "0.008''" "0.010''" "0.012''" "0.014''" "0.016''" "0.020''" "0.021''" "0.024''" "0.028''" "0.031''" "0.035''" "0.039''" "0.042''" "0.047''" "0.055''" "0.062''" "0.079''" "0.083''"))
                (setq lwa08 (list "VonLayer" "VonBlock" "Vorgabe" "0.00 mm" "0.05 mm" "0.09 mm" "0.13 mm" "0.15 mm" "0.18 mm" "0.20 mm" "0.25 mm" "0.30 mm" "0.35 mm" "0.40 mm" "0.50 mm" "0.53 mm" "0.60 mm" "0.70 mm" "0.80 mm" "0.90 mm" "1.00 mm" "1.06 mm" "1.20 mm" "1.40 mm" "1.58 mm" "2.00 mm" "2.11 mm"))
              )
              (if (not (setq lwa35 (vl-position acmlineweightchange522200520e lwa07)))
                (setq lwa35 0)
              )
            (start_list "lb_01")
            (mapcar 'add_list lwa08)
            (end_list)
            (set_tile "lb_01" (itoa lwa35))
            (set_tile "tg_01" (itoa (getvar "LWDISPLAY")))
            (action_tile "b_01" "(setq lwa36 (atoi (get_tile \"tg_01\"))) (setq acmlineweightchange522200520e (nth (atoi (get_tile \"lb_01\")) lwa07)) (setq lwa19 (list acmlineweightchange522200520e (atoi (get_tile \"tg_01\")))) (done_dialog)")
            (action_tile "b_02" "(setq lwa19 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog lwa15)
          )
        )
      lwa19
    )
  (if (law01)
    (progn
      (vl-load-com)
      (setq lwa37 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq lwa38 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq lwa06 *error*)
      (setq *error* law02)
      (vla-EndUndoMark lwa38)
      (vla-StartUndoMark lwa38)
      (law06)
      (prompt "\nMit ACM-LSTAERKEANPASSEN zu bearbeitende Objekte whlen ... ")
        (if
          (and
            (setq lwa39 (ssget "_:L"))
            (setq lwa40 (law07))
          )
            (progn
              (law03 lwa39 lwa40)
            )
        )
        (if lwa06
          (setq *error* lwa06)
          (setq *error* nil)
        )
      (setvar "CMDECHO" lwa37)
      (vla-EndUndoMark lwa38)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-LSTAERKEANPASSEN (Copyright  2022 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-LSTAERKEANPASSEN auf.")
